/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.exceptions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementKt;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0002\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nR\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0005R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/exposed/exceptions/ExposedSQLException;", "Ljava/sql/SQLException;", "", "", "causedByQueries", "()Ljava/util/List;", "", "getErrorCode", "()I", "getSQLState", "()Ljava/lang/String;", "toString", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "contexts", "Ljava/util/List;", "getContexts", "originalSQLException", "Ljava/sql/SQLException;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "", "cause", "<init>", "(Ljava/lang/Throwable;Ljava/util/List;Lorg/jetbrains/exposed/sql/Transaction;)V", "exposed-core"})
public final class ExposedSQLException
extends SQLException {
    @NotNull
    private final List<StatementContext> contexts;
    @NotNull
    private final Transaction transaction;
    @Nullable
    private final SQLException originalSQLException;

    public ExposedSQLException(@Nullable Throwable cause, @NotNull List<StatementContext> contexts, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        super(cause);
        this.contexts = contexts;
        this.transaction = transaction2;
        this.originalSQLException = cause instanceof SQLException ? (SQLException)cause : null;
    }

    @NotNull
    public final List<StatementContext> getContexts() {
        return this.contexts;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> causedByQueries() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.contexts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            StatementContext statementContext = (StatementContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                string = this.transaction.getDebug() ? StatementKt.expandArgs((StatementContext)it, this.transaction) : it.sql(this.transaction);
            }
            catch (Throwable e) {
                String string2;
                try {
                    Statement<?> statement = it.getStatement();
                    AbstractQuery abstractQuery = statement instanceof AbstractQuery ? (AbstractQuery)statement : null;
                    string2 = abstractQuery == null ? null : abstractQuery.prepareSQL(new QueryBuilder(!this.transaction.getDebug()));
                }
                catch (Throwable e2) {
                    string2 = null;
                }
                String string3 = string2;
                string = string3 == null ? "Failed on expanding args for " + (Object)((Object)it.getStatement().getType()) + ": " + it.getStatement() : string3;
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String getSQLState() {
        SQLException sQLException = this.originalSQLException;
        String string = sQLException == null ? null : sQLException.getSQLState();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getErrorCode() {
        int n;
        SQLException sQLException = this.originalSQLException;
        return sQLException == null ? 0 : (n = sQLException.getErrorCode());
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + "\nSQL: " + this.causedByQueries();
    }
}

